#include <iostream>
#include <cstdio>
#include <vector>
#include <array>
#include <string>
#include <algorithm>
#include <numeric>
#include <map>
#include <unordered_map>
#include <set>
#include <unordered_set>
#include <queue>
#include <cmath>
#include <climits>
#include <iomanip>
#include <limits>
#include <tuple>
#include <stack>
#include <bitset>
#include <cstring>
#include <sstream>
#include <functional>
#include <random>
using namespace std;

using ll = long long;

void solve() {
    int n;
    cin >> n;
    vector<pair<ll, ll>> sx(n), sy(n);
    for (int i = 0; i < n; ++i) {
        ll x, y;
        cin >> x >> y;
        sx[i].first = x, sx[i].second = y;
        sy[i].first = y, sy[i].second = x;
    }
    sort(sx.begin(), sx.end());
    sort(sy.begin(), sy.end());
    map<ll, ll> cnt21, cnt22;
    for (int i = 0; i < n; ++i) {
        cnt21[sx[i].first - sx[i].second]++;
        cnt22[sx[i].first + sx[i].second]++;
    }
    ll ans = 0;
    for (auto& e : cnt21) {
        ll c = e.second;
        ans += c * (c - 1) / 2;
    }
    for (auto& e : cnt22) {
        ll c = e.second;
        ans += c * (c - 1) / 2;
    }
    ans *= 2;
    for (int i = 0; i < n;) {
        ll x = sx[i].first;
        ll p = 0, np = 0;
        while (i < n && sx[i].first == x) {
            if ((sx[i].second & 1ll) == 0) {
                p++;
            }
            else {
                np++;
            }
            ++i;
        }
        ans += p * (p - 1) / 2;
        ans += np * (np - 1) / 2;
    }
    for (int i = 0; i < n;) {
        ll y = sy[i].first;
        ll p = 0, np = 0;
        while (i < n && sy[i].first == y) {
            if ((sy[i].second & 1ll) == 0) {
                p++;
            }
            else {
                np++;
            }
            ++i;
        }
        ans += p * (p - 1) / 2;
        ans += np * (np - 1) / 2;
    }   
    cout << ans << '\n';
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    solve();
    return 0;
}